/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.StringDescription;
import org.hamcrest.core.Every;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;

public class EveryTest {
    @Test
    public void isTrueWhenEveryValueMatches() {
        MatcherAssert.assertThat(Arrays.asList("AaA", "BaB", "CaC"), (Matcher)Every.everyItem((Matcher)StringContains.containsString((String)"a")));
        MatcherAssert.assertThat(Arrays.asList("AbA", "BbB", "CbC"), (Matcher)IsNot.not((Matcher)Every.everyItem((Matcher)StringContains.containsString((String)"a"))));
    }

    @Test
    public void isAlwaysTrueForEmptyLists() {
        MatcherAssert.assertThat(new ArrayList(), (Matcher)Every.everyItem((Matcher)StringContains.containsString((String)"a")));
    }

    @Test
    public void describesItself() {
        Every each = new Every(StringContains.containsString((String)"a"));
        Assert.assertEquals((Object)"every item is a string containing \"a\"", (Object)each.toString());
        StringDescription description = new StringDescription();
        each.matchesSafely(Arrays.asList("BbB"), (Description)description);
        Assert.assertEquals((Object)"an item was \"BbB\"", (Object)description.toString());
    }
}

